/*
 *  Copyright 2007 by Spectrum Digital Incorporated.
 *  All rights reserved. Property of Spectrum Digital Incorporated.
 */

/*
 *  Definitions & Register
 *
 */

#ifndef VPSS_H_
#define VPSS_H_

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Variable types                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */

#define Uint32  unsigned int
#define Uint16  unsigned short
#define Uint8   unsigned char
#define Int32   int
#define Int16   short
#define Int8    char
//typedef int 	STATUS;

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Software Breakpoint code                                                *
 *      Uses inline assembly command                                        *
 *                                                                          *
 * ------------------------------------------------------------------------ */

#define SW_BREAKPOINT    asm( " .long 0xE1200070" );

#define WR_MEM_32(addr, data)    *(unsigned int*)(addr) =(unsigned int)(data)
#define RD_MEM_32(addr) 		 *(unsigned int*)(addr)

#define HDVPSS_BASE_ADDR	0x48100000	// HDVPSS: HD Video Processing Subsystem
#define HDVPSS_END_ADDR		0x4811FFFF

#define DVO2_BASE_ADDR		(HDVPSS_BASE_ADDR + 0xA000)	// VOUT0 module

#define DVO2_CFG0		(DVO2_BASE_ADDR + 0x00)
#define DVO2_CFG1		(DVO2_BASE_ADDR + 0x04)
#define DVO2_CFG2		(DVO2_BASE_ADDR + 0x08)
#define DVO2_CFG3		(DVO2_BASE_ADDR + 0x0C)
#define DVO2_CFG4		(DVO2_BASE_ADDR + 0x10)
#define DVO2_CFG5		(DVO2_BASE_ADDR + 0x14)
#define DVO2_CFG6		(DVO2_BASE_ADDR + 0x18)
#define DVO2_CFG7		(DVO2_BASE_ADDR + 0x1C)
#define DVO2_CFG8		(DVO2_BASE_ADDR + 0x20)
#define DVO2_CFG9		(DVO2_BASE_ADDR + 0x24)
#define DVO2_CFG10		(DVO2_BASE_ADDR + 0x28)
#define DVO2_CFG11		(DVO2_BASE_ADDR + 0x2C)
#define DVO2_CFG12		(DVO2_BASE_ADDR + 0x30)
#define DVO2_CFG13		(DVO2_BASE_ADDR + 0x34)
#define DVO2_CFG14		(DVO2_BASE_ADDR + 0x38)
#define DVO2_CFG15		(DVO2_BASE_ADDR + 0x3C)
#define DVO2_CFG16		(DVO2_BASE_ADDR + 0x40)
#define DVO2_CFG17		(DVO2_BASE_ADDR + 0x44)
#define DVO2_CFG18		(DVO2_BASE_ADDR + 0x48)
#define DVO2_CFG19		(DVO2_BASE_ADDR + 0x4C)
#define DVO2_CFG20		(DVO2_BASE_ADDR + 0x50)
#define DVO2_CFG21		(DVO2_BASE_ADDR + 0x54)
#define DVO2_CFG22		(DVO2_BASE_ADDR + 0x58)
#define DVO2_CFG23		(DVO2_BASE_ADDR + 0x5C)
#define DVO2_CFG24		(DVO2_BASE_ADDR + 0x60)
#define DVO2_CFG25		(DVO2_BASE_ADDR + 0x64)

/* ------------------------------------------------------------------------ *
 *  Prototypes                                                              *
 * ------------------------------------------------------------------------ */

Int16 LCD_VPSS_Config(void);

#endif /*VPSS_H_*/

